import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import objectos_casa.*;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;

/**
 * Created by Pedro on 20/04/2016.
 */
public class Casa implements Serializable{
    String nome_casa;
    String tipo_valor_retorno;
    ObjectoCasa[][]casa;
    ObjectosPermitidosCoordCasa[][]permite;
    Boolean permiteRecursividade;
    int tamanho_x;
    int tamanho_y;
    int ultimo_id; //id reservados: -1(objecto null)  0(blank)  1(def_func)  2(function_call do def_func)

    //cada entrada no hashmap contem:
    //      <objecto,   array com os limites de coordenadas a permitir o seu uso>
    //e o array contem os dados:
    //[x_inicio, x_fim, y_inicio, y_fim]
    HashMap<ObjectoCasa,Integer[]> variaveis;

    //funcoes disponiveis dentro da casa
    ArrayList<Function_call> funcoesDisponiveis;

    public Casa() {
        nome_casa = "Casa";
        tipo_valor_retorno="void";
        casa = new ObjectoCasa[20][10];
        for(int a=0;a<20;a++)
            for(int b=0;b<10;b++)
                casa[a][b]=new ObjectoCasa() {
                    @Override
                    public String gerar() {
                        return null;
                    }

                    @Override
                    public String to_expressao() {
                        return null;
                    }
                };

        permiteRecursividade=false;
        tamanho_x=20;
        tamanho_y=10;
        ultimo_id=2;
        variaveis = new HashMap<>(1);
        funcoesDisponiveis = new ArrayList<>(1);

        permite = new ObjectosPermitidosCoordCasa[20][10];
        for(int i=0;i<tamanho_x;i++)
            for(int c=0;c<tamanho_y;c++)
                permite[i][c]=new ObjectosPermitidosCoordCasa();

        casa[0][0]=new Blank(0);
        permite[0][0].def_func = true;
        permite[0][0].outros = true;
        permite[0][0].nenhum=false;

        for (int i = 0; i < 20; i++) {
            permite[i][0].inicializarResChao();
            casa[i][0]=new Blank(0);
        }

    }

    public Casa(String nome_func, String tipoRetorno, int x_size, int y_size){
        if(nome_func==null||nome_func.equals("")) {
            throw new IllegalArgumentException("O nome da casa é inválido! Por favor introduza um nome para a casa.");
        }
        if(tipoRetorno==null||tipoRetorno.equals(""))
            tipo_valor_retorno="void";

        if(x_size>1&&y_size>1) {
            nome_casa = nome_func;
            tipo_valor_retorno=tipoRetorno;
            casa = new ObjectoCasa[x_size][y_size];

            for(int a=0;a<x_size;a++)
                for(int b=0;b<y_size;b++)
                    casa[a][b]=new ObjectoCasa() {
                        @Override
                        public String gerar() {
                            return null;
                        }

                        @Override
                        public String to_expressao() {
                            return null;
                        }
                    };


            permiteRecursividade=false;
            tamanho_x = x_size;
            tamanho_y = y_size;
            ultimo_id=2;
            variaveis = new HashMap<>(1);
            funcoesDisponiveis = new ArrayList<>(1);


            permite = new ObjectosPermitidosCoordCasa[x_size][y_size];
            for(int i=0;i<tamanho_x;i++)
                for(int c=0;c<tamanho_y;c++)
                    permite[i][c]=new ObjectosPermitidosCoordCasa();

            casa[0][0]=new Blank(0);
            permite[0][0].def_func = true;
            permite[0][0].nenhum = false;

            for (int i = 1; i < x_size; i++) {
                permite[i][0].inicializarResChao();
                casa[i][0]=new Blank(0);
            }

        }
        else{
            throw new IllegalArgumentException("Dimensões da casa inválida! O tamanho x e y têm de ser maiores que 0.");
        }

    }

    public Boolean colocarNovoObjecto(int x, int y, String tipo) throws IOException{
        int posicao_limite;
        int posicoes_disponiveis;
        int novoId=ultimo_id+1;
        ObjectoCasa novo;
        BufferedReader buff=new BufferedReader(new InputStreamReader(System.in));


        if(x<0 || x>=tamanho_x || y<0 || y>=tamanho_y) {
            System.err.println("Coordenadas dadas para o objecto são inválidas! X tem de estar entre 0 e " +
                    (tamanho_x-1) + " e Y tem de estar entre 0 e " + (tamanho_y-1) + ".");
            return false;
        }

        if(permite[x][y].nenhum){
            System.err.println("Nenhum objecto é permitido nesta posição!");
            return false;
        }

        if(casa[x][y].tipo_objecto().equals("null")||casa[x][y].tipo_objecto().equals("blank")) {

            switch (tipo) {

                case "array_double": case"array_int": case "array_string": case "boolean": case "char": case "double":
                case "int": case "string":
                    //verificar se uma variavel pode ser colocada nesta posicao
                    if (permite[x][y].outros) {

                        //cria um array com as posicoes validas da variavel
                        Integer temp_var[]= {x + 1, tamanho_x-1, y, tamanho_y-1};

                        //verificar se esta encontra-se dentro de um switch ou if e caso esteja calcula o limite das posições
                        // válidas dentro desse bloco
                        int fim_x=checkDentroIfElseSwitch(x,y);

                        //mete as posicoes validas no caso de esta dentro de um switch/if
                        if(fim_x!=-1){
                            temp_var[1] = fim_x-1;
                            temp_var[3] = y;
                        }

                        //se nao estiver dentro de um switch/if
                        else if(fim_x==-1) {
                            // verifica se encontra-se dentro de um ciclo
                            fim_x = checkDentroCiclo(x, y);
                            //mete as posicoes validas no caso de estar dentro de um ciclo
                            if (fim_x != -1)
                                temp_var[1] = fim_x - 1;
                        }

                        if(tipo.equals("array_double"))
                            novo= new Array_double("array_double"+novoId,novoId);

                        else if(tipo.equals("array_int"))
                            novo= new Array_int("array_int"+novoId,novoId);

                        else if(tipo.equals("array_string"))
                            novo= new Array_string("array_string"+novoId,novoId);

                        else if(tipo.equals("boolean"))
                            novo= new Boolean_casa("boolean"+novoId,novoId);

                        else if(tipo.equals("char"))
                            novo= new Char_casa("char"+novoId,novoId);

                        else if(tipo.equals("double"))
                            novo= new Double_casa("double"+novoId,novoId);

                        else if(tipo.equals("int"))
                            novo= new Int_casa("int"+novoId,novoId);

                        else
                            novo= new String_casa("string"+novoId,novoId);

                        variaveis.put(novo, temp_var);
                        casa[x][y] = novo;
                        ultimo_id++;
                        return true;
                    }

                    else {
                        System.err.println("Nenhuma variável é permitido nesta posição!");
                        return false;
                    }

                case "begin_for_ciclo":

                    Begin_for_ciclo temp_for = new Begin_for_ciclo(novoId,"x"+novoId,1,1,1);

                    //calcular posicoes validas a seguir a este objecto
                    posicoes_disponiveis = numeroPosicoesValidasBloco(x,y);
                    if(posicoes_disponiveis<2) {
                        System.err.println("Não é possível inserir um ciclo neste local por falta de espaço!");
                        return false;
                    }

                    End_ciclo temp_end_for= new End_ciclo(novoId+1,x);
                    int input_for;

                    //calcular o limite do final do ciclo
                    posicao_limite = posicoes_disponiveis+x+1;

                    //permitir end_ciclo nas posicoes disponiveis
                    for(int i=x+1;i<posicao_limite;i++)
                        permite[i][y].end_switch_if_ciclo=true;

                    do{
                        //receber input da posicao x do end_ciclo
                        input_for=inputColocarFimBloco(x,posicao_limite);

                        //interromper se o utilizador "cancelar"
                        if(input_for==-1) {
                            System.err.println("Colocação do ciclo for foi cancelada!");

                            //reverter a permissao end_ciclo nas posicoes utilizadas
                            for(int i=x+1;i<posicao_limite;i++)
                                permite[i][y].end_switch_if_ciclo=false;

                            return false;
                        }

                            //tentar colocar end_ciclo
                        if(permite[input_for][y].end_switch_if_ciclo) {
                            casa[input_for][y] = temp_end_for;
                            break; //interromper ciclo se for bem sucedido
                        }
                        else{//continuar enquanto falhar
                            System.err.println("Falha em colocar o fim do ciclo! Tente noutra posição ou escreva" +
                                    " a palavra \"cancelar\" para cancelar a colocação deste ciclo.");
                        }

                    }while(true);

                    //actualizar permissoes entre os dois objectos
                    for(int c1=x+1;c1<input_for;c1++)
                        for(int c2=y;c2<tamanho_y;c2++) {
                            permite[c1][c2].break_e_continue = true;
                        }
                    //guardar objecto do begin_for
                    casa[x][y]=temp_for;

                    //reverter a permissao end_ciclo nas posicoes utilizadas
                    for(int i=x+1;i<posicao_limite;i++)
                        permite[i][y].end_switch_if_ciclo=false;

                    //adicionar variavel iteradora na lista de variaveis para esta zona
                    Integer[] iterador_coords={x+1,input_for-1,y,tamanho_y-1};
                    variaveis.put(temp_for.iterador,iterador_coords);

                    ultimo_id+=2;

                    //devolver true
                    return true;


                case "begin_while_ciclo":

                    //calcular posicoes validas a seguir a este objecto
                    posicoes_disponiveis = numeroPosicoesValidasBloco(x,y);
                    if(posicoes_disponiveis<2) {
                        System.err.println("Não é possível inserir um ciclo neste local por falta de espaço!");
                        return false;
                    }

                    End_ciclo temp_end_while = new End_ciclo(novoId+1,x);
                    int input_while;

                    //calcular o limite do final do ciclo
                    posicao_limite = posicoes_disponiveis+x+1;

                    //permitir end_ciclo nas posicoes disponiveis
                    for(int i=x+1;i<posicao_limite;i++)
                        permite[i][y].end_switch_if_ciclo=true;

                    do{
                        //receber input da posicao x do end_ciclo
                        input_while=inputColocarFimBloco(x,posicao_limite);

                        //interromper se o utilizador "cancelar"
                        if(input_while==-1) {
                            System.err.println("Colocação do ciclo while foi cancelada!");

                            //reverter a permissao end_ciclo nas posicoes utilizadas
                            for(int i=x+1;i<posicao_limite;i++)
                                permite[i][y].end_switch_if_ciclo=false;

                            return false;
                        }
                        //tentar colocar end_ciclo
                        if(permite[input_while][y].end_switch_if_ciclo) {
                            casa[input_while][y] = temp_end_while;
                            break; //interromper ciclo se for bem sucedido
                        }

                        else{//continuar enquanto falhar
                            System.err.println("Falha em colocar o fim do ciclo! Tente noutra posição ou escreva" +
                                    " a palavra \"cancelar\" para cancelar a colocação deste ciclo.");
                        }

                    }while(true);


                    //actualizar permissoes entre os dois objectos
                    for(int c1=x+1;c1<input_while;c1++)
                        for(int c2=y;c2<tamanho_y;c2++) {
                            permite[c1][c2].break_e_continue = true;
                        }

                    //reverter a permissao end_ciclo nas posicoes utilizadas
                    for(int i=x+1;i<posicao_limite;i++)
                        permite[i][y].end_switch_if_ciclo=false;

                    //guardar objecto do begin_while
                    casa[x][y]=new Begin_while_ciclo(novoId,constructorExpr("boolean",getListaVars(x,y)));

                    ultimo_id+=2;

                    //devolver true
                    return true;

                case "begin_if":
                    if(permite[x][y].begin_if_e_switch){

                        //calcular posicoes validas a seguir a este objecto
                        posicoes_disponiveis = numeroPosicoesValidasBloco(x,y);
                        if(posicoes_disponiveis<2||y+1>=tamanho_y) {
                            System.err.println("Não é possível inserir um If neste local por falta de espaço!");
                            return false;
                        }

                        End_if temp_end_if=new End_if(novoId+1,x);
                        int input_if;

                        //calcular o limite do final do if
                        posicao_limite = posicoes_disponiveis+x+1;

                        //permitir end_if nas posicoes disponiveis
                        for(int i=x+1;i<posicao_limite;i++)
                            permite[i][y].end_switch_if_ciclo=true;

                        do{
                            //receber input da posicao x do end_if
                            input_if=inputColocarFimBloco(x,posicao_limite);

                            //interromper se o utilizador "cancelar"
                            if(input_if==-1) {
                                System.err.println("Colocação do bloco If foi cancelada!");

                                //reverter a permissao end_if nas posicoes utilizadas
                                for(int i=x+1;i<posicao_limite;i++)
                                    permite[i][y].end_switch_if_ciclo=false;

                                return false;
                            }

                            //tentar colocar end_if
                            if(permite[input_if][y].end_switch_if_ciclo) {
                                casa[input_if][y]=temp_end_if;
                                break; //interromper ciclo se for bem sucedido
                            }
                            else{//continuar enquanto falhar
                                System.err.println("Falha em colocar o fim do If! Tente noutra posição ou escreva" +
                                        " a palavra \"cancelar\" para cancelar a colocação deste bloco If.");
                            }

                        }while(true);

                        //actualizar permissoes entre os dois objectos
                        for(int c1=x+1;c1<input_if;c1++){
                            permite[c1][y].inicializarNovoAndarSwitchIf();
                            permite[c1][y+1].inicializarNovoAndarSwitchIf();
                            casa[c1][y+1]=new Blank(0);
                        }

                        //reverter a permissao end_if nas posicoes utilizadas
                        for(int i=x+1;i<posicao_limite;i++)
                            permite[i][y].end_switch_if_ciclo=false;

                        //guardar objecto begin_if
                        casa[x][y]=new Begin_if(novoId,constructorExpr("boolean",getListaVars(x,y)));

                        ultimo_id+=2;

                        //devolver true
                        return true;


                    }
                    else
                        System.err.println("Não é possível colocar o If dentro de um If ou Switch!");

                    return false;

                case "begin_switch":
                    if(permite[x][y].begin_if_e_switch){

                        //calcular posicoes validas a seguir a este objecto
                        posicoes_disponiveis = numeroPosicoesValidasBloco(x,y);
                        if(posicoes_disponiveis<2||y+1>=tamanho_y) {
                            System.err.println("Não é possível inserir um switch neste local por falta de espaço!");
                            return false;
                        }

                        //calcular o limite do final do begin_switch
                        posicao_limite = posicoes_disponiveis + x + 1;

                        //permitir end_switch nas posicoes disponiveis
                        for(int i=x+1;i<posicao_limite;i++)
                            permite[i][y].end_switch_if_ciclo=true;

                        End_switch temp_end_switch = new End_switch(novoId+1,0);
                        int input_switch;

                        do{
                            input_switch=inputColocarFimBloco(x,posicao_limite);

                            //interromper se o utilizador "cancelar"
                            if(input_switch==-1) {
                                System.err.println("Colocação do bloco Switch foi cancelada!");

                                //reverter as regras modificadas na colocacao do end_switch
                                for(int i=x+1;i<posicao_limite;i++)
                                    permite[i][y].end_switch_if_ciclo=false;

                                return false;
                            }

                            //tentar colocar end_switch
                            if(permite[input_switch][y].end_switch_if_ciclo) {
                                casa[input_switch][y]=temp_end_switch;
                                break; //interromper ciclo se for bem sucedido
                            }
                            else{//continuar enquanto falhar
                                System.err.println("Falha em colocar o fim do switch! Tente noutra posição ou escreva" +
                                        " a palavra \"cancelar\" para cancelar a colocação deste bloco Switch.");
                            }

                        }while(true);

                        //reverter as regras modificadas na colocacao do end_switch
                        for(int i=x+1;i<posicao_limite;i++)
                            permite[i][y].end_switch_if_ciclo=false;

                        //actualizar permissoes entre os dois objectos
                        for(int c1=x+1;c1<input_switch;c1++){
                            permite[c1][y].inicializarNovoAndarSwitchIf();
                            permite[c1][y+1].inicializarNovoAndarSwitchIf();
                        }

                        //permitir switch_case e end_switch para o proximo andar
                        permite[x][y+1].switch_case=true;
                        permite[x][y+1].nenhum=false;
                        permite[input_switch][y+1].end_switch_if_ciclo=true;
                        permite[input_switch][y+1].nenhum=false;

                        //guardar objecto begin_switch
                        casa[x][y]=new Begin_switch(novoId);

                        ultimo_id+=2;

                        //devolver true
                        return true;
                    }
                    else
                        System.err.println("Não é possível colocar o Switch dentro de um If ou Switch!");

                    return false;

                case "switch_case":
                    if(permite[x][y].switch_case){

                        //incializar posicao do end do switch
                        int pos_end=0;

                        //procurar o final do switch
                        for(int i=x+1;i<tamanho_x;i++)
                            if(permite[i][y].end_switch_if_ciclo) {
                                pos_end = i;
                                break;
                            }
                        if(pos_end==0) {
                            System.err.println("Não é possível encontrar a posição válida para o final do Switch Case!");
                            return false;
                        }

                        //guardar switch_case e end_switch
                        casa[x][y]=new Switch_case(novoId, constructorExpr("boolean",getListaVars(x,y)),true);
                        casa[pos_end][y] = new End_switch(novoId+1,x);

                        //verificar e actualizar que este é o ultimo andar
                        if(casa[x][y-1].tipo_objecto().equals("switch_case"))
                            ((Switch_case)casa[x][y-1]).ultimo=false;

                        //inicializar novo andar, actualizar as regras nesse andar
                        for(int i=x+1;i<pos_end;i++){
                            casa[i][y]=new Blank(0);
                            permite[i][y].inicializarNovoAndarSwitchIf();
                        }

                        //no caso de haver espaco para outro andar
                        if(y+1<tamanho_y) {

                            //permitir outro switch_case no andar de cima
                            permite[x][y + 1].switch_case = true;
                            permite[x][y + 1].nenhum = false;

                            //e permite o end_switch para esse switch_case
                            permite[pos_end][y + 1].end_switch_if_ciclo = true;
                            permite[pos_end][y + 1].nenhum = false;
                        }

                        ultimo_id+=2;

                        return true;
                    }

                    else{
                        System.err.println("Não é possível colocar o Switch_case nesta posição!");
                    }
                    return false;

                case "continue":
                    if(permite[x][y].break_e_continue) {
                        casa[x][y] = new Continue_casa(novoId);
                        ultimo_id++;
                        return true;
                    }
                    else{
                        System.err.println("Não é possível colocar um Continue fora de um ciclo!");
                        return false;
                    }

                case "break":
                    if(permite[x][y].break_e_continue) {
                        casa[x][y] = new Continue_casa(novoId);
                        ultimo_id++;
                        return true;
                    }
                    else{
                        System.err.println("Não é possível colocar um Break fora de um ciclo!");
                        return false;
                    }

                case "def_func":
                    if(permite[x][y].def_func){
                        casa[x][y] = new Def_func(1,nome_casa);
                        if(permiteRecursividade)
                            permitirRecursividade();
                        return true;
                    }
                    else{
                        System.err.println("Só é possivel por este objecto na posição x=0 e y=0 da casa!");
                        return false;
                    }

                case "return":
                    String exp="";
                    if(casa[0][0].tipo_objecto().equals("def_func")) {
                        exp = constructorExpr(tipo_valor_retorno, getListaVars(x, y));
                        casa[x][y] = new Return_casa(novoId, exp);
                    }
                    else
                        System.err.println("Não está definida nenhuma função para poder-se usar o return!");
                    break;


                //ALTERAR MAIS TARDE PARA ACEITAR O USO DE ARRAYS EM ATRIBUICOES
                case "maquina_boolean": case "maquina_char": case "maquina_double": case "maquina_int":
                case "maquina_string":
                    String exp_maquina="";
                    String var_nome="";
                    ArrayList<ObjectoCasa> lista_vars=getListaVars(x,y);
                    if(permite[x][y].outros) {
                        if(tipo.equals("maquina_boolean")) {
                            System.out.println("Variáveis disponíveis para a atribuição:");
                            for(ObjectoCasa o:lista_vars){
                                if(o.tipo_objecto().equals("boolean")){
                                    System.out.println(((Boolean_casa)o).nome);
                                }
                            }
                            do{
                                System.out.println("Escreva o nome da variavel a aplicar a atribuição:");
                                var_nome=buff.readLine();
                                if(var_nome.equals("cancelar"))
                                    return false;
                                else if(getVarCasa(var_nome)!=null)
                                    break;
                                else
                                    System.out.println("Variável inválida. Tente outra vez ou escreva \"cancelar\" para " +
                                            "retornar ao menu anterior.");
                            }while(true);

                            exp_maquina=constructorExpr("boolean",getListaVars(x,y));
                            casa[x][y] = new Maquina_boolean(var_nome, exp_maquina, novoId);
                        }


                        else if(tipo.equals("maquina_char")) {
                            System.out.println("Variáveis disponíveis para a atribuição:");
                            for(ObjectoCasa o:lista_vars){
                                if(o.tipo_objecto().equals("char")){
                                    System.out.println(((Char_casa)o).nome);
                                }
                            }
                            do{
                                System.out.println("Escreva o nome da variavel a aplicar a atribuição:");
                                var_nome=buff.readLine();
                                if(var_nome.equals("cancelar"))
                                    return false;
                                else if(getVarCasa(var_nome)!=null)
                                    break;
                                else
                                    System.out.println("Variável inválida. Tente outra vez ou escreva \"cancelar\" para " +
                                            "retornar ao menu anterior.");
                            }while(true);

                            exp_maquina=constructorExpr("char",getListaVars(x,y));
                            casa[x][y] = new Maquina_char(var_nome, exp_maquina, novoId);
                        }


                        else if(tipo.equals("maquina_double")) {
                            System.out.println("Variáveis disponíveis para a atribuição:");
                            for(ObjectoCasa o:lista_vars){
                                if(o.tipo_objecto().equals("double")){
                                    System.out.println(((Double_casa)o).nome);
                                }
                            }
                            do{
                                System.out.println("Escreva o nome da variavel a aplicar a atribuição:");
                                var_nome=buff.readLine();
                                if(var_nome.equals("cancelar"))
                                    return false;
                                else if(getVarCasa(var_nome)!=null)
                                    break;
                                else
                                    System.out.println("Variável inválida. Tente outra vez ou escreva \"cancelar\" para " +
                                            "retornar ao menu anterior.");
                            }while(true);


                            exp_maquina=constructorExpr("double",getListaVars(x,y));
                            casa[x][y] = new Maquina_double(var_nome, exp_maquina, novoId);
                        }


                        else if(tipo.equals("maquina_int")) {
                            System.out.println("Variáveis disponíveis para a atribuição:");
                            for(ObjectoCasa o:lista_vars){
                                if(o.tipo_objecto().equals("int")){
                                    System.out.println(((Int_casa)o).nome);
                                }
                            }
                            do{
                                System.out.println("Escreva o nome da variavel a aplicar a atribuição:");
                                var_nome=buff.readLine();
                                if(var_nome.equals("cancelar"))
                                    return false;
                                else if(getVarCasa(var_nome)!=null)
                                    break;
                                else
                                    System.out.println("Variável inválida. Tente outra vez ou escreva \"cancelar\" para " +
                                            "retornar ao menu anterior.");
                            }while(true);

                            exp_maquina=constructorExpr("int",getListaVars(x,y));
                            casa[x][y] = new Maquina_int(var_nome, exp_maquina, novoId);
                        }


                        else {
                            System.out.println("Variáveis disponíveis para a atribuição:");
                            for(ObjectoCasa o:lista_vars){
                                if(o.tipo_objecto().equals("string")){
                                    System.out.println(((String_casa)o).nome);
                                }
                            }
                            do{
                                System.out.println("Escreva o nome da variavel a aplicar a atribuição:");
                                var_nome=buff.readLine();
                                if(var_nome.equals("cancelar"))
                                    return false;
                                else if(getVarCasa(var_nome)!=null)
                                    break;
                                else
                                    System.out.println("Variável inválida. Tente outra vez ou escreva \"cancelar\" para " +
                                            "retornar ao menu anterior.");
                            }while(true);


                            exp_maquina=constructorExpr("string",getListaVars(x,y));
                            casa[x][y] = new Maquina_string(var_nome, exp_maquina, novoId);
                        }
                        ultimo_id++;
                        return true;
                    }
                    else{
                        System.err.println("Não é possível colocar este objecto nesta posição!");
                        return false;
                    }

                case "function_call":
                    System.err.println("Só é possível colocar uma function_call já existente!");
                    return false;

                case "end_if":
                    System.err.println("Só é possível colocar um end_if juntamente com um begin_if!");
                    return false;

                case "end_ciclo":
                    System.err.println("Só é possível colocar um end_ciclo juntamente com um begin_while_ciclo ou " +
                            "com um begin_for_ciclo!");
                    return false;

                case "end_switch":
                    System.err.println("Só é possível colocar um end_switch juntamente com um begin_switch ou " +
                            "com um switch_case!");
                    return false;

                case "blank":
                    System.err.println("Blank é inserido automáticamente com o editor da casa, não sendo necessário " +
                            "colocar este tipo de objectos manualmente.");
                    return false;

                default:
                    System.err.println("Objecto casa desconhecido ou inválido!");
                    return false;
            }

        }
        else{
            System.err.println("Esta posição está ocupada!");
        }
        return false;
    }

    public Boolean colocarFuncao(int x, int y, Function_call func) throws IOException{
        Boolean check_funcao=(funcoesDisponiveis.contains(func));
        String input_linha;
        BufferedReader buff= new BufferedReader(new InputStreamReader(System.in));


        if(permite[x][y].outros && check_funcao){
            for(int i = 0; i < func.argumentos.size(); i++)
            {
                System.out.println("Para o argumento "+func.argumentos.get(i)+" do tipo "+func.tipo_argumentos.get(i)+
                        "escreva o valor ou variável a utilizar:");
                System.out.println("(ATENÇÃO: Não é feita verificação dos valores ou variáveis introduzidos.))");
                input_linha=buff.readLine();
            }
            casa[x][y] = func;
            return true;
        }
        else{
            if(!check_funcao)
                System.err.println("Não é possível colocar a chamada de função nesta posição!");

            else
                System.err.println("A função chamada não está disponível nesta casa!");

            return false;
        }
    }

    public void modificarObjecto(int x, int y) throws IOException{
        ObjectoCasa objectoLido= casa[x][y];
        String input_linha;
        BufferedReader buff= new BufferedReader(new InputStreamReader(System.in));
        if(objectoLido.tipo_objecto().equals("null")||objectoLido.tipo_objecto().equals("blank")) {
            System.out.println("Não existe um objecto editável nesta posição.");
            return;
        }
        switch(objectoLido.tipo_objecto()){
            case "array_double":
                Array_double array_d=(Array_double)casa[x][y];
                do{
                    System.out.println("Dados no array:");
                    System.out.println("Nome: " + array_d.nome);
                    System.out.println("Lista:");
                    array_d.printLista();
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar lista");

                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do array: " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    array_d.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou não escreva nada " +
                                            "para cancelar a operação.");

                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Lista:");
                                array_d.printLista();
                                System.out.println("\n\nOperações permitidas:");
                                System.out.println("0:Fechar editor da lista   1:Editar valor da lista   " +
                                        "2:Apagar valor da lista\n3:Adicionar novo valor ao final da lista");
                                input_linha = buff.readLine();
                                if(input_linha.equals("0"))
                                    break;

                                else if(input_linha.equals("1")) {
                                    do {
                                        System.out.println("Introduza o número da posição do valor a alterar:");
                                        input_linha = buff.readLine();
                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_d.tamanho) {
                                                do {
                                                    System.out.println("Introduza o novo valor:");
                                                    input_linha = buff.readLine();
                                                    if (input_linha.equals("cancelar"))
                                                        break;
                                                    if (isDouble(input_linha)) {
                                                        array_d.setElem(Double.parseDouble(input_linha), temp);
                                                        break;
                                                    }
                                                    else
                                                        System.err.println("Valor inválido! Se quiser cancelar a " +
                                                                "operação escreva \"cancelar\".");

                                                }while (true);
                                            }
                                            else
                                                System.err.println("Número de posição inválido!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");

                                    }while (true);
                                }
                                else if(input_linha.equals("2")){
                                    do {
                                        System.out.println("Introduza o número da posição do valor a apagar da lista:");
                                        input_linha = buff.readLine();

                                        if (input_linha.equals("cancelar"))
                                            break;

                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_d.tamanho) {
                                                array_d.removeElem(temp);
                                                break;
                                            }
                                            else
                                                System.err.println("Valor inválido!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");

                                    }while (true);

                                } else if (input_linha.equals("3")) {
                                    do {
                                        System.out.println("Introduza o número do valor a adicionar à lista:");
                                        input_linha = buff.readLine();

                                        if (input_linha.equals("cancelar"))
                                            break;

                                        if (isDouble(input_linha)) {
                                            Double temp = Double.parseDouble(input_linha);
                                            array_d.addElem(temp);
                                            break;
                                        } else
                                            System.err.println("Número double inválido! Introduza apenas números com virgula" +
                                                    " ou escreva \"cancelar\" para cancelar a operação.");

                                    } while (true);
                                } else
                                    System.err.println("Input inválido! Tente outra vez.");

                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }
                    break;
                }while(true);

                casa[x][y]=array_d;
                break;


            case"array_int":
                Array_int array_i=(Array_int)casa[x][y];
                do{
                    System.out.println("Dados no array:");
                    System.out.println("Nome: " + array_i.nome);
                    System.out.println("Lista:");
                    array_i.printLista();
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar lista");

                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do array: " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    array_i.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Lista:");
                                array_i.printLista();
                                System.out.println("\n\nOperações permitidas:");
                                System.out.println("0:Fechar editor da lista   1:Editar valor da lista   " +
                                        "2:Apagar valor da lista\n3:Adicionar novo valor ao final da lista");
                                input_linha = buff.readLine();
                                if(input_linha.equals("0"))
                                    break;

                                else if(input_linha.equals("1")) {
                                    do {
                                        System.out.println("Introduza o número da posição do valor a alterar:");
                                        input_linha = buff.readLine();
                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_i.tamanho) {
                                                do {
                                                    System.out.println("Introduza o novo valor:");
                                                    input_linha = buff.readLine();
                                                    if (input_linha.equals("cancelar"))
                                                        break;
                                                    if (isInt(input_linha)) {
                                                        array_i.setElem(Integer.parseInt(input_linha), temp);
                                                        break;
                                                    }
                                                    else
                                                        System.err.println("Valor inválido! Se quiser cancelar a " +
                                                                "operação escreva \"cancelar\".");

                                                }while (true);
                                            }
                                            else
                                                System.err.println("Número de posição inválido!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");

                                    }while (true);
                                }
                                else if(input_linha.equals("2")){
                                    do {
                                        System.out.println("Introduza o número da posição do valor a apagar da lista:");
                                        input_linha = buff.readLine();

                                        if (input_linha.equals("cancelar"))
                                            break;

                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_i.tamanho) {
                                                array_i.removeElem(temp);
                                                break;
                                            }
                                            else
                                                System.err.println("Valor inválido!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");

                                    }while (true);

                                } else if (input_linha.equals("3")) {
                                    do {
                                        System.out.println("Introduza o número do valor a adicionar à lista:");
                                        input_linha = buff.readLine();

                                        if (input_linha.equals("cancelar"))
                                            break;

                                        if (isDouble(input_linha)) {
                                            int temp = Integer.parseInt(input_linha);
                                            array_i.addElem(temp);
                                            break;
                                        } else
                                            System.err.println("Número inteiro inválido! Introduza apenas números sem" +
                                                    " virgula ou escreva \"cancelar\" para cancelar a operação.");

                                    } while (true);
                                } else
                                    System.err.println("Input inválido! Tente outra vez.");

                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }
                    break;
                }while(true);

                casa[x][y]=array_i;
                break;


            case "array_string":
                Array_string array_s=(Array_string)casa[x][y];

                do{
                    System.out.println("Dados no array:");
                    System.out.println("Nome: " + array_s.nome);
                    System.out.println("Lista:");
                    array_s.printLista();
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar lista");

                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do array: " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    array_s.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Lista:");
                                array_s.printLista();
                                System.out.println("\n\nOperações permitidas:");
                                System.out.println("0:Fechar editor da lista   1:Editar valor da lista   " +
                                        "2:Apagar valor da lista\n3:Adicionar novo valor ao final da lista");
                                input_linha = buff.readLine();
                                if(input_linha.equals("0"))
                                    break;

                                else if(input_linha.equals("1")) {
                                    do {
                                        System.out.println("Introduza o número da posição do valor a alterar:");
                                        input_linha = buff.readLine();
                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_s.tamanho) {
                                                System.out.println("Introduza o novo valor:");
                                                input_linha = buff.readLine();
                                                array_s.setElem(input_linha, temp);
                                                break;
                                            }
                                            else
                                                System.err.println("Número da posição inválido!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");
                                    }while (true);
                                }
                                else if(input_linha.equals("2")){
                                    do {
                                        System.out.println("Introduza o número da posição do valor a apagar da lista:");
                                        input_linha = buff.readLine();

                                        if (apenasNumeros(input_linha)){
                                            int temp=Integer.parseInt(input_linha);
                                            if(temp>=0&&temp<array_s.tamanho) {
                                                array_s.removeElem(temp);
                                                break;
                                            }
                                            else
                                                System.err.println("Posição inválida!");
                                        }
                                        else
                                            System.err.println("Input inválido! Introduza apenas números ou escreva \"cancelar\" para" +
                                                    " cancelar a operação.");

                                    }while (true);

                                } else if (input_linha.equals("3")) {

                                    System.out.println("Introduza a string a adicionar à lista:");
                                    input_linha = buff.readLine();

                                    array_s.addElem(input_linha);
                                    break;

                                } else
                                    System.err.println("Input inválido! Tente outra vez.");

                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }
                    break;
                }while(true);

                casa[x][y]=array_s;
                break;


            case "boolean":
                Boolean_casa bool=(Boolean_casa)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + bool.nome);
                    System.out.println("Valor: " + bool.getValor());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alternar valor");
                    input_linha = buff.readLine();
                    switch(input_linha){

                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    bool.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            bool.switchValor();
                            System.err.println("O objecto tem agora o valor booleano: "+bool.valor);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }

                    break;
                }while(true);

                casa[x][y]=bool;
                break;

            case "char":
                Char_casa chara=(Char_casa)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + chara.nome);
                    System.out.println("Valor: " + chara.getValor());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar valor");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    chara.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            System.out.println("Introduza o caracter a guardar como valor:");
                            input_linha = (char) buff.read() + "";
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }
                    break;
                }while(true);

                casa[x][y]=chara;
                break;


            case "double":
                Double_casa doub=(Double_casa)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + doub.nome);
                    System.out.println("Valor: " + doub.getValor());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar valor");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    doub.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Introduza o novo número double a guardar como valor no objecto:");
                                input_linha=buff.readLine();
                                if(input_linha.equals("cancelar"))
                                    break;
                                if(isDouble(input_linha)) {
                                    doub.setValor(Double.parseDouble(input_linha));
                                    break;
                                }
                                else
                                    System.err.println("Valor double inválido! Use apenas números com virgula flutuante" +
                                            " ou escreva \"cancelar\" para cancelar a operação.");
                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=doub;
                break;


            case "int":
                Int_casa inte=(Int_casa)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + inte.nome);
                    System.out.println("Valor: " + inte.getValor());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar valor");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    inte.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Introduza o novo número int a guardar como valor no objecto:");
                                input_linha=buff.readLine();
                                if(input_linha.equals("cancelar"))
                                    break;
                                if(isInt(input_linha)) {
                                    inte.setValor(Integer.parseInt(input_linha));
                                    break;
                                }
                                else
                                    System.err.println("Valor int inválido! Use apenas números sem virgula flutuante" +
                                            " ou escreva \"cancelar\" para cancelar a operação.");
                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=inte;
                break;

            case "string":
                String_casa str=(String_casa)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + str.nome);
                    System.out.println("Valor: " + str.valor);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar valor");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    str.nome = input_linha;
                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            System.out.println("Introduza o texto a guardar como valor:");
                            str.valor = buff.readLine();
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;
                    }
                    break;
                }while(true);

                casa[x][y]=str;
                break;

            case "begin_for_ciclo":
                Begin_for_ciclo ciclo_f=(Begin_for_ciclo)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome iterador: " + ciclo_f.iterador.nome);
                    System.out.println("Valor inicial do ciclo: " + ciclo_f.valor_inicial);
                    System.out.println("Valor final do ciclo: " + ciclo_f.valor_final);
                    System.out.println("Valor somado ao iterador por cada ciclo: " + ciclo_f.op_iterador);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome do iterador   2:Alterar Valores   " +
                            "3:Alterar expressão");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta variável tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais.");
                                input_linha = buff.readLine();
                                if (input_linha.equals(""))
                                    break;
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome da variável tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    Integer temp_coords[]=variaveis.remove(ciclo_f.iterador);
                                    ciclo_f.iterador.nome = input_linha;
                                    variaveis.put(ciclo_f.iterador,temp_coords);

                                    break;
                                } else
                                    System.err.println("Nome da variável já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;


                        case "2":
                            do{
                                System.out.println("Opções:");
                                System.out.println("0:Retornar ao menu anterior   1:Alterar valor inicial   " +
                                        "2:Alterar valor final");
                                input_linha=buff.readLine();
                                if(input_linha.equals("0"))
                                    break;
                                else if(input_linha.equals("1")){
                                    do{
                                        System.out.println("Introduza o novo número como valor inicial do iterador no " +
                                                "ciclo:");
                                        input_linha=buff.readLine();
                                        if(input_linha.equals("cancelar"))
                                            break;
                                        if(isInt(input_linha)) {
                                            ciclo_f.valor_inicial=Integer.parseInt(input_linha);
                                            break;
                                        }
                                        else
                                            System.err.println("Valor inválido! Use apenas números" +
                                                    " ou escreva \"cancelar\" para cancelar a operação.");
                                    }while(true);
                                }
                                else if(input_linha.equals("2")){
                                    do{
                                        System.out.println("Introduza o novo número como valor final do iterador no " +
                                                "ciclo:");
                                        input_linha=buff.readLine();
                                        if(input_linha.equals("cancelar"))
                                            break;
                                        if(isInt(input_linha)) {
                                            ciclo_f.valor_final=Integer.parseInt(input_linha);
                                            break;
                                        }
                                        else
                                            System.err.println("Valor inválido! Use apenas números" +
                                                    " ou escreva \"cancelar\" para cancelar a operação.");
                                    }while(true);
                                }

                            }while(true);
                            continue;

                        case "3":
                            do{
                                System.out.println("Introduza o novo número a adicionar ao iterador por cada ciclo:");
                                input_linha=buff.readLine();
                                if(input_linha.equals("cancelar"))
                                    break;
                                if(isInt(input_linha)) {
                                    ciclo_f.valor_final=Integer.parseInt(input_linha);
                                    break;
                                }
                                else
                                    System.err.println("Valor inválido! Use apenas números" +
                                            " ou escreva \"cancelar\" para cancelar a operação.");
                            }while(true);
                            continue;


                        default:
                            System.err.println("Opção inválida! Escolha uma das 4 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=ciclo_f;
                break;

            case "begin_while_ciclo":
                Begin_while_ciclo ciclo_w=(Begin_while_ciclo)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Expressão condicional: " + ciclo_w.condicao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar expressão");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            String temp_str=constructorExpr("boolean", getListaVars(x,y));
                            if(!temp_str.equals(""))
                                ciclo_w.condicao=temp_str;
                            else
                                System.out.println("A operação foi cancelada!");
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 2 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=ciclo_w;
                break;

            case "end_ciclo":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "begin_if":
                Begin_if begin_if=(Begin_if)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Expressão: " + begin_if.getExpressao());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar Expressão");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            String temp_str=constructorExpr("boolean", getListaVars(x,y));
                            if(!temp_str.equals(""))
                                begin_if.setExpressao(temp_str);
                            else
                                System.out.println("A operação foi cancelada!");
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 2 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=begin_if;
                break;

            case "end_if":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "begin_switch":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "switch_case":
                Switch_case switch_c=(Switch_case)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Expressão condicional: " + switch_c.getExpressao());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar expressão");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            String temp_str=constructorExpr("boolean", getListaVars(x,y));
                            if(!temp_str.equals(""))
                                switch_c.setExpressao(temp_str);
                            else
                                System.out.println("A operação foi cancelada!");
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 2 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=switch_c;
                break;

            case "end_switch":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "break":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "continue":
                System.out.println("Não existe um objecto editável nesta posição.");
                return;

            case "def_func":
                Def_func d_func=(Def_func)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + d_func.nome);
                    System.out.println("Parâmetros: " + d_func.parametrosToString());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar nome   2:Alterar parâmetros");
                    input_linha = buff.readLine();

                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("\nInsira o novo nome do "+objectoLido.tipo_objecto()+": " +
                                        "\n(NOTA: Isto NÃO altera o nome dos locais onde esta função tenha sido usada, sendo" +
                                        " necessário alterar o nome manualmente nestes locais."+
                                        "\n(NOTA2: Alterar o nome deste objecto altera também o nome da casa.");
                                input_linha = buff.readLine();
                                if (input_linha.equals("")) {
                                    System.out.println("Operação cancelada.");
                                    break;
                                }
                                else if (Character.isDigit(input_linha.charAt(0))) {
                                    System.err.println("O nome de uma função tem de sempre começar com uma letra!");
                                    continue;
                                } else if (checkNomeDisponivel(input_linha)) {
                                    if(permiteRecursividade)
                                        for(Function_call f:funcoesDisponiveis) {
                                            if(f.nome.equals(d_func.nome)) {
                                                f.nome = input_linha;
                                                break;
                                            }
                                        }
                                    d_func.nome = input_linha;
                                    nome_casa=input_linha;
                                    break;
                                } else
                                    System.err.println("Nome já utilizado! Tente outro nome ou envie a " +
                                            "string vazia para cancelar a operação.");
                            } while (true);
                            continue;

                        case "2":
                            do{
                                System.out.println("Parâmetros: " + d_func.parametrosToString());
                                System.out.println("\nOperações permitidas:");
                                System.out.println("0:Fechar editor de parâmetros   1:Editar nome de um parâmetro " +
                                        "  2:Adicionar novo parâmetro   3:Remover parâmetro");
                                input_linha=buff.readLine();
                                if(input_linha.equals("0"))
                                    break;
                                else if(input_linha.equals("1")) {
                                    do {
                                        System.out.println("Introduza o número do parâmetro a alterar:");
                                        input_linha = buff.readLine();
                                        if (apenasNumeros(input_linha)) {
                                            int pos = Integer.parseInt(input_linha) - 1;
                                            if (pos < 0 || pos > d_func.parametros.size()) {
                                                System.err.println("Número do parâmetro inválido!");
                                                continue;
                                            }

                                            System.out.println("Introduza o novo nome do parâmetro:");
                                            input_linha = buff.readLine();

                                            if (Character.isDigit(input_linha.charAt(0))) {
                                                System.err.println("O nome de um parâmetro tem de sempre começar com uma letra!");
                                                continue;
                                            }

                                            if (!checkNomeDisponivel(input_linha)) {
                                                System.err.println("O nome do parâmetro já existe! Tem de ser um nome único.");
                                                continue;
                                            }

                                            Integer[] pos_array = variaveis.remove(d_func.parametros.get(pos));
                                            d_func.setNomeParametro(pos, input_linha);

                                            variaveis.put(d_func.parametros.get(pos), pos_array);
                                            break;
                                        } else
                                            System.err.println("Número do parâmetro inválido! Input contêm letras.");
                                    } while (true);
                                }

                                else if(input_linha.equals("2")){
                                    do {
                                        System.out.println("Introduza o nome do novo parâmetro:");
                                        input_linha = buff.readLine();
                                        if (Character.isDigit(input_linha.charAt(0))) {
                                            System.err.println("O nome de um parâmetro tem de sempre começar com uma letra!");
                                            continue;
                                        }
                                        if(!checkNomeDisponivel(input_linha)) {
                                            System.err.println("O nome do parâmetro já existe! Tem de ser um nome único.");
                                            continue;
                                        }
                                        String nome_temp=input_linha;
                                        ObjectoCasa novoParam;

                                        do {
                                            System.out.println("Seleccione o tipo do parâmetro:");
                                            System.out.println("0: int   1: double   2: string   3: char   4: boolean   " +
                                                    "5: array_int   6: array_double   7: array_string");
                                            input_linha=buff.readLine();
                                            Integer[] coords={x + 1, tamanho_x-1, y, tamanho_y-1};
                                            switch(input_linha){
                                                case "0":
                                                    novoParam=new Int_casa(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)){
                                                                f.addArg(nome_temp,"int");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;
                                                case "1":
                                                    novoParam=new Double_casa(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "double");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "2":
                                                    novoParam=new String_casa(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "string");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "3":
                                                    novoParam=new Char_casa(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "char");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "4":
                                                    novoParam=new Boolean_casa(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "boolean");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "5":
                                                    novoParam=new Array_int(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "array_int");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "6":
                                                    novoParam=new Array_double(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "array_double");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                case "7":
                                                    novoParam=new Array_string(nome_temp,ultimo_id+1);
                                                    d_func.addParametro(novoParam);
                                                    variaveis.put(novoParam,coords);
                                                    if(permiteRecursividade)
                                                        for(Function_call f:funcoesDisponiveis) {
                                                            if(f.nome.equals(d_func.nome)) {
                                                                f.addArg(nome_temp, "array_string");
                                                                break;
                                                            }
                                                        }
                                                    ultimo_id++;
                                                    break;

                                                default:
                                                    System.err.println("Input do tipo inválido! Tente novamente.");
                                                    continue;
                                            }
                                            break;
                                        }while(true);

                                        break;
                                    }while(true);

                                }

                                else if(input_linha.equals("3")){
                                    do {
                                        System.out.println("Introduza o número do parâmetro a remover:");
                                        input_linha = buff.readLine();
                                        if(input_linha.equals("cancelar"))
                                            break;
                                        if (apenasNumeros(input_linha)) {
                                            int pos = Integer.parseInt(input_linha) - 1;
                                            if (pos < 0 || pos > d_func.parametros.size()) {
                                                System.err.println("Número do parâmetro inválido! Tente outra vez ou " +
                                                        "escreva \"cancelar\" para voltar ao menu anterior.");
                                                continue;
                                            }
                                            variaveis.remove(d_func.parametros.get(pos));
                                            d_func.removeParametro(pos);
                                            if(permiteRecursividade)
                                                for(Function_call f:funcoesDisponiveis) {
                                                    if(f.nome.equals(d_func.nome)) {
                                                        f.removeArg(pos);
                                                        break;
                                                    }
                                                }
                                            break;
                                        }
                                    }while(true);
                                }

                            }while(true);
                            continue;


                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=d_func;
                break;

            case "function_call":
                Function_call f_call=(Function_call)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome: " + f_call.nome);
                    System.out.println("Argumentos usados: "+f_call.printArgumentosTipos());
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar argumentos");
                    input_linha = buff.readLine();


                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            do{
                                System.out.println("Seleccione o número do argumento a alterar:");
                                input_linha=buff.readLine();
                                if(!apenasNumeros(input_linha)){
                                    System.err.println("Número do parâmetro inválido! Input contêm letras.");
                                    continue;
                                }
                                int pos=Integer.parseInt(input_linha)-1;
                                if(pos<0||pos>f_call.argumentos.size()){
                                    System.err.println("Número do parâmetro inválido!");
                                    continue;
                                }
                                do {
                                    System.out.println("Escreva o nome da variável (com tipo válido) a usar no argumento:");
                                    input_linha = buff.readLine();
                                    ObjectoCasa var=getVarCasa(input_linha);
                                    String tipo_arg=f_call.tipo_argumentos.get(pos);
                                    if (var != null && var.tipo_objecto().contains(tipo_arg)) {
                                        if(var.tipo_objecto().contains("array")&&!tipo_arg.contains("array"))
                                            f_call.argumentos.set(pos,getElem(var));
                                        else
                                            f_call.argumentos.set(pos,var.to_expressao());
                                        break;
                                    }
                                    else
                                        System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                                }while(true);


                                break;
                            }while(true);
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 2 opções.");
                            continue;
                    }

                    break;
                }while(true);

                casa[x][y]=f_call;
                break;

            case "maquina_boolean":
                Maquina_boolean m_bool=(Maquina_boolean)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome da variavel a alterar: " + m_bool.variavel);
                    System.out.println("Expressão utilizada no assign: " + m_bool.expressao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Alterar nome da variavel   2:Alterar a expressão");
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("Escreva o nome da variável (com tipo válido) a usar no assignment:");
                                input_linha = buff.readLine();
                                ObjectoCasa var_lido=getVarCasa(input_linha);
                                if (var_lido != null && var_lido.tipo_objecto().equals("boolean")) {
                                    m_bool.variavel=input_linha;
                                    break;
                                }
                                else
                                    System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                            }while(true);

                            continue;

                        case "2":
                            m_bool.expressao=constructorExpr("boolean",getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=m_bool;
                break;

            case "maquina_char":
                Maquina_char m_char=(Maquina_char)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome da variavel a alterar: " + m_char.variavel);
                    System.out.println("Expressão utilizada no assign: " + m_char.expressao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Alterar nome da variavel   2:Alterar a expressão");
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("Escreva o nome da variável (com tipo válido) a usar no assignment:");
                                input_linha = buff.readLine();
                                ObjectoCasa var_lido=getVarCasa(input_linha);
                                if (var_lido != null && var_lido.tipo_objecto().equals("char")) {
                                    m_char.variavel=input_linha;
                                    break;
                                }
                                else
                                    System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                            }while(true);

                            continue;

                        case "2":
                            m_char.expressao=constructorExpr("char",getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);

                casa[x][y]=m_char;
                break;


            case "maquina_double":
                Maquina_double m_doub=(Maquina_double)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome da variavel a alterar: " + m_doub.variavel);
                    System.out.println("Expressão utilizada no assign: " + m_doub.expressao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Alterar nome da variavel   2:Alterar a expressão");
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("Escreva o nome da variável (com tipo válido) a usar no argumento:");
                                input_linha = buff.readLine();
                                ObjectoCasa var_lido=getVarCasa(input_linha);
                                if (var_lido != null && var_lido.tipo_objecto().contains("double")) {
                                    if(var_lido.tipo_objecto().contains("array"))
                                        m_doub.variavel=getElem(var_lido);
                                    else
                                        m_doub.variavel=input_linha;
                                    break;
                                }
                                else
                                    System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                            }while(true);

                            continue;

                        case "2":
                            m_doub.expressao=constructorExpr("double",getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);


                casa[x][y]=m_doub;
                break;




            case "maquina_int":
                Maquina_int m_int=(Maquina_int)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome da variavel a alterar: " + m_int.variavel);
                    System.out.println("Expressão utilizada no assign: " + m_int.expressao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Alterar nome da variavel   2:Alterar a expressão");
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("Escreva o nome da variável (com tipo válido) a usar no argumento:");
                                input_linha = buff.readLine();
                                ObjectoCasa var_lido=getVarCasa(input_linha);
                                if (var_lido != null && var_lido.tipo_objecto().contains("int")) {
                                    if(var_lido.tipo_objecto().contains("array"))
                                        m_int.variavel=getElem(var_lido);
                                    else
                                        m_int.variavel=input_linha;
                                    break;
                                }
                                else
                                    System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                            }while(true);

                            continue;

                        case "2":
                            m_int.expressao=constructorExpr("int",getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);


                casa[x][y]=m_int;
                break;

            case "maquina_string":
                Maquina_string m_str=(Maquina_string)casa[x][y];

                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Nome da variavel a alterar: " + m_str.variavel);
                    System.out.println("Expressão utilizada no assign: " + m_str.expressao);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Alterar nome da variavel   2:Alterar a expressão");
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            break;

                        case "1":
                            do {
                                System.out.println("Escreva o nome da variável (com tipo válido) a usar no argumento:");
                                input_linha = buff.readLine();
                                ObjectoCasa var_lido=getVarCasa(input_linha);
                                if (var_lido != null && var_lido.tipo_objecto().contains("string")) {
                                    if(var_lido.tipo_objecto().contains("array"))
                                        m_str.variavel=getElem(var_lido);
                                    else
                                        m_str.variavel=input_linha;
                                    break;
                                }
                                else
                                    System.err.println("Nome da variável não existe ou não são do mesmo tipo!");

                            }while(true);

                            continue;

                        case "2":
                            m_str.expressao=constructorExpr("string",getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 3 opções.");
                            continue;

                    }
                    break;
                }while(true);


                casa[x][y]=m_str;
                break;

            case "return":
                Return_casa ret=(Return_casa)casa[x][y];
                do {
                    System.out.println("Dados no objecto " + objectoLido.tipo_objecto() + ":");
                    System.out.println("Expressão de retorno: " + ret.expressao_valor_retorno);
                    System.out.println("\nOperações permitidas:");
                    System.out.println("0:Fechar editor   1:Editar expressão");
                    input_linha = buff.readLine();
                    switch(input_linha){
                        case "0":
                            break;

                        case "1":
                            ret.expressao_valor_retorno=constructorExpr(tipo_valor_retorno,getListaVars(x,y));
                            continue;

                        default:
                            System.err.println("Opção inválida! Escolha uma das 2 opções.");
                            continue;
                    }
                    break;
                }while(true);
        }
    }

    public void removerObjecto(int x, int y) throws IOException{
        BufferedReader buff= new BufferedReader(new InputStreamReader(System.in));
        String input_linha;

        if(casa[x][y].tipo_objecto().equals("null")) {
            System.err.println("Não existe um objecto para remover neste espaço!");
            return;
        }

        switch(casa[x][y].tipo_objecto()){
            case "array_double": case"array_int": case "array_string":
            case "boolean": case "char": case "double": case "int": case "string":
                variaveis.remove(casa[x][y]);
                if(permite[x][y].outros)
                    casa[x][y]=new Blank(0);
                else
                    casa[x][y]=new ObjectoCasa() {
                        @Override
                        public String gerar() {
                            return null;
                        }

                        @Override
                        public String to_expressao() {
                            return null;
                        }
                    };
                System.out.println("Objecto removido. (NOTA: Isto NÃO remove o nome nos locais onde esta variável tenha\n" +
                        "sido usada, sendo necessário remover o nome deste manualmente nos repectivos locais.)");
                break;

            case "def_func":
                Def_func temp=(Def_func)casa[x][y];
                if(permiteRecursividade)
                    for(Function_call f:funcoesDisponiveis) {
                        if(f.nome.equals(temp.nome)) {
                            funcoesDisponiveis.remove(f);
                            break;
                        }
                    }

                for(ObjectoCasa par: temp.parametros)
                    variaveis.remove(par);

                casa[x][y]=new Blank(0);
                System.out.println("Objecto removido. (NOTA: Isto NÃO remove o nome nos locais onde esta função e\n " +
                        "argumentos tenham sido usados, sendo necessário remover o nome destes manualmente nos repectivos locais.)");
                break;

            case "return": case "maquina_boolean": case "maquina_char": case "maquina_double": case "maquina_int":
            case "maquina_string": case "function_call": case "continue": case "break":
                casa[x][y]=new ObjectoCasa() {
                    @Override
                    public String gerar() {
                        return null;
                    }

                    @Override
                    public String to_expressao() {
                        return null;
                    }
                };;
                break;

            case "begin_if":
                System.out.println("ATENÇÃO: TODOS os objectos dentro do bloco if serão também apagados. Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")){
                    casa[x][y]=new Blank(0);

                    for(int a=x+1 ; a<tamanho_x ; a++)
                        for(int b=y+1 ; b>=0 ; b--) {
                            if (casa[a][b].tipo_objecto().equals("null"))
                                break;

                            else if (casa[a][b].tipo_objecto().equals("end_if")){
                                casa[a][b]=new Blank(0);
                                return;
                            }
                            else{
                                if(b>0)
                                    permite[a][b].removerAndarSwitchIf();
                                else if(b==0){
                                    permite[a][b].begin_if_e_switch=true;
                                }
                                removerObjecto(a,b);
                            }
                        }
                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;

            case "end_if":
                System.out.println("ATENÇÃO: TODOS os objectos dentro do bloco if serão também apagados. " +
                        "Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")) {
                    removerObjecto(((End_if) casa[x][y]).getCoord(), y);
                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;

            case "begin_while_ciclo": case "begin_for_ciclo":

                System.out.println("ATENÇÃO: TODOS os objectos dentro do bloco while serão também apagados. Deseja continuar (S/N)?");
                input_linha=buff.readLine();
                Boolean entre_ciclo=checkDentroCiclo(x,y)!=-1;

                if(input_linha.equals("S")||input_linha.equals("s")){
                    if(casa[x][y].tipo_objecto().equals("begin_for_ciclo"))
                        variaveis.remove(((Begin_for_ciclo)casa[x][y]).iterador);

                    //verificar se ao apagar coloca no espaco blank ou null
                    if(permite[x][y].outros)
                        casa[x][y]=new Blank(0);
                    else
                        casa[x][y]=new ObjectoCasa() {
                            @Override
                            public String gerar() {
                            return null;
                        }

                            @Override
                            public String to_expressao() {
                            return null;
                        }
                        };


                    for(int a=x+1 ; a<tamanho_x ; a++)
                        for(int b=y ; b<tamanho_y ; b++) {
                            if (casa[a][b].tipo_objecto().equals("null"))
                                break;
                            if (casa[a][b].tipo_objecto().equals("end_ciclo")){
                                if(permite[x][y].outros)
                                    casa[x][y]=new Blank(0);
                                else
                                    casa[x][y]=new ObjectoCasa() {
                                        @Override
                                        public String gerar() {
                                            return null;
                                        }

                                        @Override
                                        public String to_expressao() {
                                            return null;
                                        }
                                    };
                                return;
                            }
                            else {
                                if(!entre_ciclo)
                                    permite[a][b].break_e_continue = false;
                                removerObjecto(a, b);
                            }
                        }
                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;

            case "end_ciclo":
                System.out.println("ATENÇÃO: TODOS os objectos dentro do ciclo serão também apagados. " +
                        "Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")) {
                    removerObjecto(((End_ciclo) casa[x][y]).coord_inicio, y);
                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;


            case "begin_switch":
                System.out.println("ATENÇÃO: TODOS os objectos dentro e acima do switch serão também apagados. " +
                        "Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")) {
                    casa[x][y]=new Blank(0);

                    int fim_switch=0;
                    for(int i=x+1;i<tamanho_x;i++)
                        if(casa[i][y].tipo_objecto().equals("end_switch")){
                            fim_switch=i;
                            break;
                        }

                    for(int a=x ; a<=fim_switch ; a++)
                        for(int b=y ; b<tamanho_y ; b++) {
                            if (casa[a][b].tipo_objecto().equals("null"))
                                break;
                            else {
                                if(b==0)
                                    permite[a][b].inicializarResChao();
                                else
                                    permite[a][b].removerAndarSwitchIf();
                                removerObjecto(a, b);
                            }
                        }

                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;


            case "switch_case":
                System.out.println("ATENÇÃO: TODOS os objectos dentro e acima do switch serão também apagados. " +
                        "Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")) {
                    casa[x][y]=new ObjectoCasa() {
                        @Override
                        public String gerar() {
                            return null;
                        }

                        @Override
                        public String to_expressao() {
                            return null;
                        }
                    };

                    int fim_switch=0;
                    for(int i=x+1;i<tamanho_x;i++)
                        if(casa[i][y].tipo_objecto().equals("end_switch")){
                            fim_switch=i;
                            break;
                        }

                    for(int a=x ; a<=fim_switch ; a++)
                        for(int b=y ; b<tamanho_y ; b++) {
                            if (casa[a][b].tipo_objecto().equals("null"))
                                break;
                            else {
                                permite[a][b].removerAndarSwitchIf();
                                removerObjecto(a, b);
                            }
                        }

                    if(y>2)
                        ((Switch_case)casa[x][y-1]).ultimo=true;

                    permite[x][y].switch_case=true;
                    permite[fim_switch][y].switch_case=true;

                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                if(casa[x][y].tipo_objecto().equals("switch_case")&&y>1)
                    ((Switch_case)casa[x][y-1]).ultimo=true;

                break;

            case "end_switch":
                System.out.println("ATENÇÃO: TODOS os objectos dentro e acima do switch serão também apagados. " +
                        "Deseja continuar (S/N)?");
                input_linha=buff.readLine();

                if(input_linha.equals("S")||input_linha.equals("s")) {
                    removerObjecto(((End_switch) casa[x][y]).getCoord(), y);
                    System.out.println("Objecto removido.");
                }
                else
                    System.out.println("Operação cancelada.");
                break;

            case "blank":
                if(!permite[x][y].outros)
                    casa[x][y]=new ObjectoCasa() {
                        @Override
                        public String gerar() {
                            return null;
                        }

                        @Override
                        public String to_expressao() {
                            return null;
                        }
                    };
                break;

            default:
                System.err.println("Objecto desconhecido ou inválido!");

        }

    }

    public int numeroPosicoesValidasBloco(int posX, int posY){
        int contador=0;
        for(int i=posX+1; i<tamanho_x; i++) {
            if (casa[i][posY].tipo_objecto().equals("blank"))
                contador++;
            else
                break;
        }

        return contador;
    }

    //devolve o boolean a indicar se a string dada contem apenas digitos numericos
    public Boolean apenasNumeros(String frase){
        for(int i=0;i<frase.length();i++) {
            if(!Character.isDigit(frase.charAt(i)))
                return false;
        }

        return true;
    }

    public int inputColocarFimBloco(int limite_inicio, int limite_fim) throws IOException{
        String linha_input;
        int inicio_input=limite_inicio+2;
        int fim_input=limite_fim-1;
        if(limite_inicio>limite_fim) {
            System.err.println("Valores de limites inválidos! O limite inicial tem de ser menor que o final.");
            return -1;
        }
        do{
            System.out.println("Em que posição x termina o bloco de instruções?");
            System.out.println("(Introduza um número de " + inicio_input + " até " + fim_input);
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            linha_input = buff.readLine();

            if(linha_input.equals("cancelar")){
                return -1;
            }

            if (linha_input.isEmpty()||!apenasNumeros(linha_input)) {
                System.err.println("Input inválido! Para cancelar a operação deve escrever a palavra \"cancelar\".");
                continue;
            }
            int temp = Integer.parseInt(linha_input);
            if(temp<=fim_input&&temp>=inicio_input) {
                return temp;
            }
            else{
                System.err.println("Input inválido! Tem de estar entre os valores indicados.");
                continue;
            }

        }while(true);

    }

    public int checkDentroIfElseSwitch(int x, int y){
        int pos=-1;

        for(int i=x;i<tamanho_x;i++) {
            if (casa[i][y].tipo_objecto().equals("end_switch") || casa[i][y].tipo_objecto().equals("end_if") ||
                    casa[i][y].tipo_objecto() == null)
                return i;
            if (casa[i][y].tipo_objecto().equals("begin_switch") || casa[i][y].tipo_objecto().equals("switch_case") ||
                    casa[i][y].tipo_objecto().equals("begin_if"))
                break;
        }
        return pos;
    }

    public int checkDentroCiclo(int x, int y){
        int pos=-1;
        int contadorBlocos=0;
        for (int i = x; i < tamanho_x; i++) {
            if (casa[i][y].tipo_objecto().equals("begin_for_ciclo") || casa[i][y].tipo_objecto().equals("begin_while_ciclo"))
                contadorBlocos++;
            if (casa[i][y].tipo_objecto().equals("end_ciclo")) {
                if (contadorBlocos <= 0) {
                    pos = i;
                    break;
                } else contadorBlocos--;
            }
        }
        return pos;
    }

    public void addFuncaoCasa(Function_call funcao){
        funcoesDisponiveis.add(funcao);
    }

    public void removeFuncaoCasa(int posicao){
        funcoesDisponiveis.remove(posicao);
    }

    public void printCasa(){
        String indent_format="%-19s%s";

        for(int y=tamanho_y-1;y>=0;y--) {
            String linha = "Linha " + y+":";
            System.out.printf(indent_format,linha,"");
            for (int x = 0; x < tamanho_x; x++) {
                System.out.printf(indent_format,casa[x][y].tipo_objecto(),"|");
            }
            System.out.println();

        }

    }

    public void printRegrasCasa(){
        String indent_format="%-19s%s";
        for(int y=tamanho_y-1;y>=0;y--) {
            String linha = "Linha " + y+":";
            System.out.printf(indent_format,linha,"");
            for (int x = 0; x < tamanho_x; x++) {
                    System.out.printf(indent_format,permite[x][y].toString(),"|");
            }
            System.out.println();

        }
    }

    public void printListaVariaveisCasa(){

        for(ObjectoCasa chave: variaveis.keySet()) {
            System.out.println("<Variavel: "+"Nome-"+chave.to_expressao()+" Tipo-"+chave.tipo_objecto()+
                    " , Conjunto de coordenadas válidas para referenciar: " + Arrays.toString(variaveis.get(chave))+">");
        }

    }

    public void printListaFuncoesCasa(){
        int temp=0;
        System.out.println("===============================");
        if(funcoesDisponiveis.isEmpty()){
            System.out.println("____Lista vazia____");
            System.out.println("===============================");
            return;
        }
        for(Function_call f:funcoesDisponiveis) {
            System.out.println("Função nº"+temp);
            System.out.println("Nome: " + f.nome);
            System.out.println("Argumentos usados: " + f.printArgumentosTipos());
            System.out.println("Tipo de valor que retorna: "+f.tipo_objecto_retorno);
            System.out.println("===============================");
            temp++;
        }
    }

    public ArrayList<ObjectoCasa> getListaVars(int x, int y){
        ArrayList<ObjectoCasa> lista= new ArrayList<>();
        for(ObjectoCasa chave: variaveis.keySet()) {
            Integer[]temp=variaveis.get(chave);
            if(x >= temp[0] && x <= temp[1] && y >= temp[2] && y <= temp[3])
                lista.add(chave);
        }
        return lista;
    }

    //funcao para adicionar function call a uma expressao
    //MODIFICAR MAIS TARDE PARA PERMITIR USAR CHAR DE STRING NUM ARGUMENTO DO TIPO CHAR
    //E USO DE FUNCTION_CALL DENTRO DE UM ARGUMENTO
    public String setFunctionCallExp(Function_call funcao, ArrayList<ObjectoCasa> listaVarsDisp) throws IOException {
        String expressao = funcao.to_expressao() + "(";
        String linha_input;
        int tamanho_args=funcao.argumentos.size();
        int tamanho_listaVars=listaVarsDisp.size();


        //enquanto a funcao tiver argumentos
        for (int a=0;a<tamanho_args;a++) {
            //escrever lista de variaveis/funcoes compativeis com arg
            ArrayList <ObjectoCasa> lista_temp=new ArrayList<>();
            String tipo_argumento = funcao.tipo_argumentos.get(a);
            int contador=0;
            for(int i=0;i<tamanho_listaVars;i++) {
                String tipo_var = listaVarsDisp.get(i).tipo_objecto();
                if (tipo_var.equals(tipo_argumento) || tipo_var.contains(tipo_argumento))
                    lista_temp.add(listaVarsDisp.get(i));
            }
            for(ObjectoCasa obj:lista_temp){
                System.out.println(contador+": "+"|tipo:"+obj.tipo_objecto()+"|"+obj.to_expressao()+'\t');
                contador++;
            }
            System.out.println(contador+": Escrever expressão");

            //pedir input da variavel ira colocar no argumento
            System.out.println("Inserir a variavel a utilizar no argumento \""+funcao.argumentos.get(a)+'\"');
            System.out.println("Escolha o número correspondente de 0 até "+(contador-1)+". " +
                    "Ou escreva \"cancelar\" para cancerlar a operação.");

            do {
                BufferedReader buff=new BufferedReader(new InputStreamReader(System.in));
                linha_input=buff.readLine();
                if(linha_input.equals("cancelar")||linha_input.equals(""))
                    return "";
                if(apenasNumeros(linha_input)) {
                    int temp=Integer.parseInt(linha_input);
                    if (0 <= temp && temp < contador){
                        ObjectoCasa adicionar=lista_temp.get(temp);
                        if(!adicionar.tipo_objecto().equals(tipo_argumento))
                            expressao+=getElem(adicionar);
                        else
                            expressao+=adicionar.to_expressao();
                        break;
                    }
                    else if(temp==contador) {
                        expressao += constructorExpr(funcao.tipo_objecto_retorno, listaVarsDisp);
                        break;
                    }
                    else
                        System.err.println("Número input fora dos limites! Tente outra vez ou escreva \"cancelar\".");
                }
                else
                    System.err.println("Input inválido! Introduza apenas números.");
            } while (true);
            if(a==tamanho_args-1)
                expressao+=")";
            else
                expressao+=", ";

        }
        return expressao;
    }

    //funcao para adicionar elemento de um array/string
    //MODIFICAR MAIS TARDE PARA ACEITAR VARIAVEIS/EXPRESSOES INT NA COORDENADA DO ELEMENTO
    public String getElem(ObjectoCasa objecto) throws IOException{
        String expressao="";
        String tipo=objecto.tipo_objecto();
        String input_linha;
        int tamanho;

        if(tipo.equals("string"))
            tamanho=((String_casa)objecto).valor.length()-1;
        else if(tipo.equals("array_int"))
            tamanho=((Array_int)objecto).lista.size()-1;
        else if(tipo.equals("array_double"))
            tamanho=((Array_double)objecto).lista.size()-1;
        else if(tipo.equals("array_string"))
            tamanho=((Array_string)objecto).lista.size()-1;
        else{
            System.err.println("Objecto inválido!");
            return expressao;
        }
        System.out.println("Introduza o número da posição do elemento a adicionar à expressão:\n");
        do {
            System.out.println("Introduza um número de 0 até "+tamanho+". Ou escreva \"cancelar\" para cancelar a operação.\n");
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            input_linha = buff.readLine();

            if(input_linha.equals("cancelar"))
                return "";

            //verificar se o input esta entre 0 e o tamanho do array/string e nao contem letras
            if(apenasNumeros(input_linha)) {
                int temp=Integer.parseInt(input_linha);

                if (0<temp&&temp<=tamanho) {
                    //adicionar a notacao [] do elemento a retirar a string da expressao
                    expressao=objecto.to_expressao()+"["+temp+"]";
                    return expressao;
                }
                else{
                    System.err.println("Número fora dos limites dados! Tente outra vez.");
                }
            }
            else{
                System.err.println("Input inválido! Apenas são aceites números.");
            }
            //repetir o ciclo caso tenha dado um input invalido ou escreva cancelar
        }while(true);
    }

    public String escreverValor(String tipo) throws IOException {
        String input_linha;
        switch(tipo){
            case "int":
                do{
                    System.out.println("Escreva um número int válido:");
                    BufferedReader buff=new BufferedReader(new InputStreamReader(System.in));
                    input_linha=buff.readLine();

                    if(input_linha.equals("")){
                        System.err.println("Input inválido! Tente novamente.");
                        continue;
                    }

                    else if(isInt(input_linha))
                        return input_linha;
                    else
                        System.err.println("Número inválido! Tente novamente.");
                }while(true);
            case "double":
                do{
                    System.out.println("Escreva um número double válido:");
                    BufferedReader buff=new BufferedReader(new InputStreamReader(System.in));
                    input_linha=buff.readLine();

                    if(input_linha.equals("")){
                        System.err.println("Input inválido! Tente novamente.");
                        continue;
                    }
                    else if(isDouble(input_linha))
                        return input_linha;

                    else
                        System.err.print("Número inválido! Tente novamente.");

                }while(true);

            case "string":
                System.out.println("Escreva o valor:");
                BufferedReader buff=new BufferedReader(new InputStreamReader(System.in));
                input_linha=buff.readLine();
                return "'"+input_linha+"'";

            case "boolean":
                do {
                    System.out.println("Escrava o valor:");
                    System.out.println("0 - true    1 - false    2 - string    3 - char    4 - int    5 - double");
                    buff = new BufferedReader(new InputStreamReader(System.in));
                    input_linha = buff.readLine();
                    switch (input_linha) {
                        case "0":
                            return "true";
                        case "1":
                            return "false";
                        case "2":
                            return escreverValor("string");
                        case "3":
                            return escreverValor("char");
                        case "4":
                            return escreverValor("int");
                        case "5":
                            return escreverValor("double");
                        default:
                            System.err.print("Opção inválida! Tente novamente.");
                            continue;
                    }
                }while(true);



            case "char":
                System.out.println("Introduza a letra:");
                buff=new BufferedReader(new InputStreamReader(System.in));
                input_linha=(char)buff.read()+"";
                return input_linha;
            default:
                System.err.println("Tipo de valor inválido!");
                return "";
        }
    }

    //recebe a string a identificar o tipo da expressao, a lista de variaveis disponiveis na posicao da expressao e
	//recebe o input do utilizador para construir e devolver a String de uma expressao
    //MODIFICAR MAIS TARDE PARA PERMITIR USO DE CHARS NA EXPRESSAO DE UMA STRING
    public String constructorExpr(String tipoExp, ArrayList<ObjectoCasa> listaVarsDisp) throws IOException {
        String expressao = "";
        String linha_input;
        ArrayList<ObjectoCasa> listaVariaveis = new ArrayList<>(1);
        ArrayList<Function_call> listaFuncoes = new ArrayList<>(1);
        ArrayList<String> listaOperadores = new ArrayList<>(1);
        ArrayList<String> listaValores = new ArrayList<>(1);
        int tamanho_lista_variaveis, tamanho_lista_funcoes, tamanho_lista_operadores, tamanho_lista_valores;

        if(tipoExp.equals("void"))
            return expressao;


        //preencher lista com simbolos de operadores conforme o tipo
        //MODIFICAR MAIS TARDE PARA PERMITIR O USO DE PARENTESIS
        if (tipoExp.equals("int") || tipoExp.equals("double")) {
            listaValores.add("Escrever número");
            listaOperadores.add("+");
            listaOperadores.add("-");
            listaOperadores.add("*");
            listaOperadores.add("/");
            listaOperadores.add("%");
        } else if (tipoExp.equals("boolean")) {
            listaValores.add("Escrever valor");
            listaOperadores.add("or");
            listaOperadores.add("and");
            listaOperadores.add(">");
            listaOperadores.add("<");
            listaOperadores.add(">=");
            listaOperadores.add("<=");
            listaOperadores.add("==");
            listaOperadores.add("!=");
            listaOperadores.add("!");
            listaOperadores.add("==");
        } else if (tipoExp.equals("char")) {
            listaValores.add("Escrever letra");
            listaValores.add("\\n");

        } else if (tipoExp.equals("string")) {
            listaValores.add("Escrever letra");
            listaValores.add("\\n");
            listaOperadores.add("+");
        }


        tamanho_lista_operadores = listaOperadores.size();
        tamanho_lista_valores = listaValores.size();


        //preencher a lista com os identificadores validos conforme o tipo da expressao

        if (tipoExp.equals("boolean")) {
            //preencher arrays, variaveis e funcoes
            listaVariaveis = listaVarsDisp;
            listaFuncoes = funcoesDisponiveis;
        }

        else{
            //preencher arrays e variaveis
            for (ObjectoCasa obj : listaVarsDisp) {
                if (obj.tipo_objecto().equals(tipoExp) || obj.tipo_objecto().equals("array_" + tipoExp))
                    listaVariaveis.add(obj);
            }

            //preencher lista de funcoes
            for (Function_call funcao : funcoesDisponiveis) {
                if (funcao.tipo_objecto_retorno.equals(tipoExp))
                    listaFuncoes.add(funcao);
            }
        }




        tamanho_lista_variaveis=listaVariaveis.size();
        tamanho_lista_funcoes=listaFuncoes.size();


        int opcao = 0;

        String print = "Simbolos:\n";

        for (String oper : listaOperadores) {
            print += opcao + ": " + oper + '\t';
            opcao++;
        }
        print+= "\nValores:\n";
        for (String valor : listaValores) {
            print += opcao + ": " + valor + '\t';
            opcao++;
        }

        print += "\nVariaveis:\n";
        for (ObjectoCasa vars : listaVariaveis) {
            print += opcao + ": " + "|" + vars.tipo_objecto() + "|" + vars.to_expressao() + '\t';
            opcao++;
        }
        print += "\nFunções:\n";
        for (Function_call funcao : listaFuncoes) {
            print += opcao + ": " + funcao.to_expressao() + '\t';
            opcao++;
        }
        System.out.println(print);

        int inputMax=tamanho_lista_funcoes+tamanho_lista_operadores+tamanho_lista_valores+tamanho_lista_variaveis;

        do{
            System.out.println("\nExpressao actualmente construída: "+expressao+'\n');
            //escolher a opcao a adicionar a lista
            System.out.println("Escreva a opção do objecto a adicionar à expressão ou escreva \"terminar\" para \n" +
                    "terminar o constructor de expressões ou \"print\" para voltar a imprimir a lista de objectos \n" +
                    "permitidos na expressão.");
            BufferedReader buff= new BufferedReader(new InputStreamReader(System.in));
            linha_input=buff.readLine();
            //se escrever "terminar" interromper o ciclo e retornar a string da expressao
            if(linha_input.equals("terminar")||linha_input.equals(""))
                return expressao;

            if(linha_input.equals("print")){
                System.out.println(print);
                continue;
            }

            if(apenasNumeros(linha_input)) {
                int temp=Integer.parseInt(linha_input);
                int indexador=0;
                //se for um simbolo de um operador
                if(indexador<=temp&&temp<tamanho_lista_operadores) {
                    expressao += listaOperadores.get(temp)+" ";
                    continue;
                }
                indexador+=tamanho_lista_operadores;


                //se for um valor
                if(indexador<=temp&&temp<indexador+tamanho_lista_valores) {
                    //se o utilizador quiser escrever o número/string/letra
                    if(temp-indexador!=0)
                        expressao+=listaValores.get(temp-indexador)+" ";
                    else
                        expressao+=escreverValor(tipoExp)+" ";
                    continue;
                }
                indexador+=tamanho_lista_valores;


                //se for uma variavel
                if(indexador<=temp&&temp<indexador+tamanho_lista_variaveis) {
                    ObjectoCasa objecto_variavel=listaVariaveis.get(temp-indexador);

                    //se for uma string
                    if(objecto_variavel.tipo_objecto().equals("string")) {
                        //perguntar se pretende-se usar tudo ou um caracter
                        do{
                            System.out.println("Pretende usar a String ou apenas uma letra?");
                            System.out.println("0: String    1:Letra    2:Cancelar");
                            linha_input=buff.readLine();
                            if(linha_input.equals("0")) {
                                expressao +=objecto_variavel.to_expressao()+" ";
                                break;
                            }
                            if(linha_input.equals("1")) {
                                expressao += getElem(objecto_variavel) + " ";
                                break;
                            }

                            if(linha_input.equals("2"))
                                break;
                            else
                                System.err.println("Input inválido! Por favor digite um número das 3 opções.");

                        }while(true);
                        //se for caracter chama getElem
                    }
                    //se for um array chama getElem
                    else if(objecto_variavel.tipo_objecto().contains("array"))
                        expressao+=getElem(objecto_variavel)+" ";
                    else
                        expressao+=objecto_variavel.to_expressao()+" ";
                    continue;
                }
                indexador+=tamanho_lista_variaveis;


                //se for uma funcao chama setFunctionCallExp
                if(indexador<=temp&&temp<indexador+tamanho_lista_funcoes) {
                    expressao += setFunctionCallExp(listaFuncoes.get(temp - indexador), listaVarsDisp);
                    continue;
                }

                //caso contrario o numero está fora das opções e repete o ciclo novamente
                System.err.println("Número fora das opções disponíveis!");
            }
            else
                System.err.println("Input inválido! Apenas são aceites números.");

        }while(true);

    }

    //codigo e regex retirado da documentacao Java6 acerca do objecto Double no metodo valueOf
    //e modificado para devolver true ou false se for um número double valido ou nao
    public Boolean isDouble(String numero){
        final String Digits     = "(\\p{Digit}+)";
        final String HexDigits  = "(\\p{XDigit}+)";
        // an exponent is 'e' or 'E' followed by an optionally
        // signed decimal integer.
        final String Exp        = "[eE][+-]?"+Digits;
        final String fpRegex    =
                ("[\\x00-\\x20]*"+  // Optional leading "whitespace"
                        "[+-]?(" + // Optional sign character

                        // A decimal floating-point string representing a finite positive
                        // number without a leading sign has at most five basic pieces:
                        // Digits . Digits ExponentPart FloatTypeSuffix
                        //
                        // Since this method allows integer-only strings as input
                        // in addition to strings of floating-point literals, the
                        // two sub-patterns below are simplifications of the grammar
                        // productions from the Java Language Specification, 2nd
                        // edition, section 3.10.2.

                        // Digits ._opt Digits_opt ExponentPart_opt FloatTypeSuffix_opt
                        "((("+Digits+"(\\.)?("+Digits+"?)("+Exp+")?)|"+

                        // . Digits ExponentPart_opt FloatTypeSuffix_opt
                        "(\\.("+Digits+")("+Exp+")?)|"+

                        // Hexadecimal strings
                        "((" +
                        // 0[xX] HexDigits ._opt BinaryExponent FloatTypeSuffix_opt
                        "(0[xX]" + HexDigits + "(\\.)?)|" +

                        // 0[xX] HexDigits_opt . HexDigits BinaryExponent FloatTypeSuffix_opt
                        "(0[xX]" + HexDigits + "?(\\.)" + HexDigits + ")" +

                        ")[pP][+-]?" + Digits + "))" +
                        "[fFdD]?))" +
                        "[\\x00-\\x20]*");// Optional trailing "whitespace"

        if (Pattern.matches(fpRegex, numero))
            return true;
        else {
            return false;
        }
    }

    public Boolean isInt(String numero){
        return numero.matches("^(-+)?\\d+$");
    }

    public void permitirRecursividade(){
        if(casa[0][0].tipo_objecto().equals("null")) {
            System.err.println("O objecto da função da casa não está definida!");
            return;
        }
        if(casa[0][0].tipo_objecto().equals("def_func")){
            Def_func temp=(Def_func)casa[0][0];
            Function_call temp2 = new Function_call(2, nome_casa, tipo_valor_retorno);
            for(ObjectoCasa obj:temp.parametros)
                temp2.addArg(obj.to_expressao(),obj.tipo_objecto());
            funcoesDisponiveis.add(temp2);
        }
        else
            System.err.println("O objecto da função da casa não está definida!");
    }

    public Boolean checkNomeDisponivel(String novo_nome){
        for(ObjectoCasa var : variaveis.keySet())
            if(var.to_expressao().equals(novo_nome))
                return false;
        for(ObjectoCasa fun : funcoesDisponiveis)
            if(fun.to_expressao().equals(novo_nome))
                return false;


        return true;
    }

    public ObjectoCasa getVarCasa(String nomeVar){
        for(ObjectoCasa o:variaveis.keySet())
            if(o.to_expressao().equals(nomeVar))
                return o;
        return null;
    }




}
